<?php
// archivo get_pieAnaEstDesGloHabTeaChartData.php
header('Content-Type: application/json');
include 'db_config.php';

// Función para eliminar acentos
function removeAccents($string) {
    return iconv('UTF-8', 'ASCII//TRANSLIT', $string);
}

// Definir la(s) tabla(s) a consultar
$tables = [
  ['name' => 'expresion_teatral']
  // Puedes agregar más tablas aquí si es necesario.
];

// Modalidades específicas (en minúsculas y sin acentos)
$modalitiesSpecific = [
    "baja intensidad y voz",
    "resistencia moderada",
    "aerobicos adaptados"
];

// Arreglos para acumular los datos por modalidad
$dataExpresion      = [];
$dataVoz            = [];
$dataControl        = [];
$dataTonos          = [];
$dataArticulacion   = [];

foreach ($tables as $table) {
    $tableName = $table['name'];
    $sql = "SELECT LOWER(TRIM(modalidad_deporte)) AS modality, 
                   SUM(puntaje_expresion) AS total_expresion, 
                   SUM(puntaje_proyectar_voz) AS total_voz, 
                   SUM(puntaje_control_corporal) AS total_control,
                   SUM(puntaje_modular_tonos) AS total_tonos,
                   SUM(puntaje_articulacion) AS total_articulacion

            FROM $tableName
            GROUP BY modality";
    $result = $conn->query($sql);
    while ($row = $result->fetch_assoc()){
        $mod = $row['modality'];
        $modNormalized = removeAccents($mod);
        // Si la modalidad normalizada no está en las específicas, agruparla como "ninguna"
        if (!in_array($modNormalized, $modalitiesSpecific)) {
            $modNormalized = "ninguna";
        }
        // Acumular puntaje de expresión
        if (!isset($dataExpresion[$modNormalized])) {
            $dataExpresion[$modNormalized] = 0;
        }
        $dataExpresion[$modNormalized] += (int)$row['total_expresion'];
        
        // Acumular puntaje de voz
        if (!isset($dataVoz[$modNormalized])) {
            $dataVoz[$modNormalized] = 0;
        }
        $dataVoz[$modNormalized] += (int)$row['total_voz'];

        // Acumular puntaje de control corporal
        if (!isset($dataControl[$modNormalized])) {
            $dataControl[$modNormalized] = 0;
        }
        $dataControl[$modNormalized] += (int)$row['total_control'];
        
        // Acumular puntaje de tonos
        if (!isset($dataTonos[$modNormalized])) {
            $dataTonos[$modNormalized] = 0;
        }
        $dataTonos[$modNormalized] += (int)$row['total_tonos'];

        // Acumular puntaje de articulacion
        if (!isset($dataArticulacion[$modNormalized])) {
            $dataArticulacion[$modNormalized] = 0;
        }
        $dataArticulacion[$modNormalized] += (int)$row['total_articulacion'];
    }
}
$conn->close();

// Preparar los arreglos de salida como arrays de objetos

$expresionData = [];
foreach ($dataExpresion as $modality => $total_expresion) {
    $expresionData[] = [
        'modality' => $modality,
        'total_expresion' => $total_expresion
    ];
}

$vozData = [];
foreach ($dataVoz as $modality => $total_voz) {
    $vozData[] = [
        'modality' => $modality,
        'total_voz' => $total_voz
    ];
}

$controlData = [];
foreach ($dataControl as $modality => $total_control) {
    $controlData[] = [
        'modality' => $modality,
        'total_control' => $total_control
    ];
}

$tonosData = [];
foreach ($dataTonos as $modality => $total_tonos) {
    $tonosData[] = [
        'modality' => $modality,
        'total_tonos' => $total_tonos
    ];
}

$articulacionData = [];
foreach ($dataArticulacion as $modality => $total_articulacion) {
    $articulacionData[] = [
        'modality' => $modality,
        'total_articulacion' => $total_articulacion
    ];
}

// Se organiza la respuesta como un objeto con tres propiedades
$response = [
    'Expresion'   => $expresionData,
    'Voz'     => $vozData,
    'Control'   => $controlData,
    'Tonos'     => $tonosData,
    'Articulacion'     => $articulacionData
];

echo json_encode($response);
?>
